// $Id: CAreaBox.cpp,v 1.3 2007/02/08 21:07:54 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CAreaBox.hpp"
using Exponent::GUI::Controls::CAreaBox;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CAreaBox, CControl);

//	===========================================================================
CAreaBox::CAreaBox(IControlRoot *root, const CRect &area) 
		: CControl(root, CControl::CCONTROL_NO_ID_REQUIRED, area, NULL)
{
	EXPONENT_CLASS_CONSTRUCTION(CAreaBox);
	this->controlIsMouseEnabled(false);
}

//	===========================================================================
CAreaBox::~CAreaBox() 
{ 
	EXPONENT_CLASS_DESTRUCTION(CAreaBox);
}

//	===========================================================================
void CAreaBox::drawControl(CGraphics &graphics)
{
	// First check if we can allow the standard handler to draw the disabled control
	if (!this->drawEnabledControl(graphics))
	{
		return;
	}

	// Draw the square
	graphics.getMutablePen()->setColour(m_frameColour);
	graphics.drawRectangle(m_normalisedArea);
}